<?php
// Check if headers are set
if (!function_exists('getallheaders')) {
    function getallheaders() {
        $headers = [];
        foreach ($_SERVER as $name => $value) {
            if (substr($name, 0, 5) == 'HTTP_') {
                $headers[str_replace(' ', '-', ucwords(strtolower(str_replace('_', ' ', substr($name, 5)))))] = $value;
            }
        }
        return $headers;
    }
}

$headers = getallheaders();
if (!isset($headers['RSG-API-KEY'])) {
    echo 'Access not allowed. Please provide the API key in the header (RSG-API-KEY).';
    exit;
}

// Get API key from header
$API_key = $headers['RSG-API-KEY'];


$valid_keys = array(
    'RSG-API-KEY-2323',
    'RSG-API-KEY-2324',
);
if (!in_array($API_key, $valid_keys)) {
    echo 'Invalid API key.';
    exit;
}
function get_product_quantity_by_sku($sku) {
    // Get product ID by SKU
    $product_id = wc_get_product_id_by_sku($sku);
    
    if ($product_id) {
        // Get product object
        $product = wc_get_product($product_id);
        
        // Get product quantity
        $quantity = $product->get_stock_quantity();
        
        return $quantity;
    } else {
        // Product not found
        return false;
    }
}

$rsgsku = $_REQUEST['sku'];
if (isset($rsgsku) || (!empty($rsgsku))) {
 
$quantity = get_product_quantity_by_sku($rsgsku);
if ($quantity !== false) {
echo $quantity;
} else {
    echo 'Product not found.';
}

}
 if (!isset($rsgsku) || empty($rsgsku)) {
     
     


$json_data = file_get_contents('php://input');
$data = json_decode($json_data, true);
if (isset($data['items']) && is_array($data['items'])) {
   
    // Function to update product quantity
    function update_product_quantity($sku, $quantity) {
        $product_id = wc_get_product_id_by_sku($sku);
        if ($product_id) {
            $product = wc_get_product($product_id);
            $product->set_stock_quantity($quantity);
            $product->save();
            return true; // Successful
        } else {
            return false; // Product not found
        }
    }
    
    $success_messages = [];
    $failure_messages = [];
    foreach ($data['items'] as $item) {
        $get_sku = $item['SKU'];
        $get_qty = $item['AvailableQuantity'];
        
        // Update product quantity
        if (update_product_quantity($get_sku, $get_qty)) {
            $success_messages[] = 'SKU: ' . $get_sku . '. Quantity: ' . $get_qty;
        } else {
            $failure_messages[] = 'Failed to update product quantity for SKU: ' . $get_sku . '. Quantity: ' . $get_qty;
        }
    }
    

    // Output success messages
    if (!empty($success_messages)) {
        echo 'Product quantity updated successfully for:' . PHP_EOL;
        foreach ($success_messages as $message) {
            echo $message . PHP_EOL;
        }
    }
    
    // Output failure messages
    if (!empty($failure_messages)) {
        echo PHP_EOL;
        echo 'Product Not Found / Failed to update :' . PHP_EOL;
        foreach ($failure_messages as $message) {
            echo $message . PHP_EOL;
        }
    }
} else {
    // Invalid JSON data
    echo 'Invalid JSON data.';
}


}
/*
// Function to send consumed quantity to RSG Store
function send_consumed_quantity($sku, $quantity) {

    $rsg_store_api_end_point = 'https://devapi.rsginventory.com/api/catalog';
    $api_secret_key = 'RSG-Dev-Api-Key';
    $data = array(
        'sku' => $sku,
        'quantity' => $quantity,
    );
    $options = array(
        'http' => array(
            'header'  => "Content-Type: application/json\r\n" .
                         "Authorization: Bearer " . $api_secret_key . "\r\n",
            'method'  => 'POST',
            'content' => json_encode($data)
        )
    );

    $context  = stream_context_create($options);
    $result = file_get_contents($rsg_store_api_end_point, false, $context);

    if ($result === FALSE) {
        echo 'Failed to send consumed quantity to third-party resource';
    } else {
        echo 'Consumed quantity sent successfully';
    }
}

// Fetch 
function fetch_quantity_from_third_party($sku) {
    // API endpoint of the third-party resource
    $rsg_store_api_end_point = 'https://third-party.com/api/quantity';

    // Third-party API credentials
    $api_secret_key = 'your_api_key';

    // Prepare GET request
    $options = array(
        'http' => array(
            'header'  => "Authorization: Bearer " . $api_secret_key . "\r\n",
            'method'  => 'GET',
        )
    );

    // Send GET request
    $context  = stream_context_create($options);
    $result = file_get_contents($rsg_store_api_end_point . '?sku=' . $sku, false, $context);

    // Check if request was successful
    if ($result === FALSE) {
        echo 'Failed to fetch quantity from third-party resource';
    } else {
        $quantity = json_decode($result, true);
        echo 'Quantity fetched successfully: ' . $quantity;
    }
}
*/
// send_consumed_quantity('your_product_sku', 10);

// fetch_quantity_from_third_party('your_product_sku');

?>
