<?php

// check quantity and update from rsg inventory if needed

function get_stock_quantity_by_sku( $sku ) {
    global $wpdb;
    $product_id = $wpdb->get_var( $wpdb->prepare( "
        SELECT post_id
        FROM $wpdb->postmeta
        WHERE meta_key = '_sku'
        AND meta_value = %s
    ", $sku ) );

    if ( $product_id ) {

        $stock_quantity = get_post_meta( $product_id, '_stock', true );
        return $stock_quantity;
    } else {
        return false; 
    }
}

// Update quantity in woocommerce

function update_product_quantity($sku, $quantity) {
        $product_id = wc_get_product_id_by_sku($sku);
        if ($product_id) {
            $product = wc_get_product($product_id);
            $product->set_stock_quantity($quantity);
            $product->save();
            return true; // Successful
        } else {
            return false; // Product not found
        }
}


// Get products with low inventory
$products = wc_get_products( array(
    'limit' => -1, // Fetch all products
    'status' => 'publish', // Only fetch published products
) );

$skus = array();

foreach ( $products as $product ) {
    $product_id = $product->get_id();
    $stock_quantity = $product->get_stock_quantity();

    if ( $stock_quantity !== '' && intval( $stock_quantity ) < 20 ) {
        $sku = $product->get_sku();
        if ( ! empty( $sku ) ) {
            $skus[] = $sku;
             
        }
    }
}

// Output SKUs
foreach ( $skus as $sku ) {
    // Construct the API URL with the dynamic SKU
    $api_url = 'https://devapi.rsginventory.com/api/catalog/' . urlencode( $sku );

    // Make the API request
    $response = wp_remote_get( $api_url, array(
        'headers' => array(
            'X-Apikey' => 'RSG-Dev-Api-Key',
        ),
    ) );

    // Check if the request was successful
  /*  if ( ! is_wp_error( $response ) && wp_remote_retrieve_response_code( $response ) === 200 ) {
        // Parse the JSON response
        $data = json_decode( wp_remote_retrieve_body( $response ), true );

        // Check if the response contains inventory data
        if ( isset( $data['inventory'] ) && ! empty( $data['inventory'] ) ) {
            echo $sku . ': ' . $data['inventory'] . '<br>';
        } elseif ( isset( $data['type'] ) && $data['type'] === '404' ) {
            echo $sku . ': SKU not found<br>';
        } elseif ( isset( $data['title'] ) && strpos( $data['title'], 'not found' ) !== false ) {
            echo $sku . ': SKU not found<br>';
        } elseif ( is_numeric( $data ) ) {
            echo $sku . ': ' . $data . '<br>'; // If the response is numeric, assume it's the inventory number
         
         
         if (update_product_quantity($sku, $data)) {
            $success_messages[] = 'SKU: ' . $sku . '. Quantity: ' . $data.'<br>';
            } else {
            $failure_messages[] = 'Failed to update product quantity for SKU: ' . $sku . '. Quantity: ' . $data.'<br>';
        } 

        $subject = 'Cron Status ID: ' . $sku;
        $message = 'SKU: ' . $sku .'<br> QTY: '. $data;
        wp_mail('twnwebexpert@gmail.com', $subject, $message);

        } else {
            echo $sku . ': Inventory not found<br>';
        }
    } else {
        echo $sku . ': Inventory not found<br><br>';
        echo"<pre>"; 
        print_r($response);
    }
    */
    
//updated condtions 
        if ( ! is_wp_error( $response ) ) {
            $response_code = wp_remote_retrieve_response_code( $response );
            $data = json_decode( wp_remote_retrieve_body( $response ), true );
        
            if ( $response_code === 200 ) {
                // Check if the response contains inventory data
                if ( isset( $data['inventory'] ) && ! empty( $data['inventory'] ) ) {
                    echo $sku . ': ' . $data['inventory'] . '<br>';
        
                    // Update product quantity
                    if ( update_product_quantity( $sku, $data['inventory'] ) ) {
                        $success_messages[] = 'SKU: ' . $sku . '. Quantity: ' . $data['inventory'] . '<br>';
                    } else {
                        $failure_messages[] = 'Failed to update product quantity for SKU: ' . $sku . '. Quantity: ' . $data['inventory'] . '<br>';
                    }
        
        
        
                } elseif ( is_numeric( $data ) ) {
                    echo $sku . ': ' . $data . '<br>'; // for numeric or interger response 
        
                    // Update product quantity
                    if ( update_product_quantity( $sku, $data ) ) {
                        $success_messages[] = 'SKU: ' . $sku . '. Quantity: ' . $data . '<br>';
                    } else {
                        $failure_messages[] = 'Failed to update product quantity for SKU: ' . $sku . '. Quantity: ' . $data . '<br>';
                    }
        
               
                } else {
                    echo $sku . ': Inventory not found<br>';
                }
                
                 
            }
            elseif ( $response_code === 404 ) {
                    echo $sku . ': SKU not found<br>';
                } 
                else {
                echo $sku . ': Inventory not found<br>';
              //  echo "<pre>";
            //    print_r( $response );
            }
        } else {
            echo $sku . ': Unknown Error Cought!<br><br>';
            //echo "<pre>"; 
           // print_r( $response );
        }
    
    
}




/*
// Function to send consumed quantity to RSG Store
function send_consumed_quantity($sku, $quantity) {

    $rsg_store_api_end_point = 'https://devapi.rsginventory.com/api/catalog';
    $api_secret_key = 'RSG-Dev-Api-Key';
    $data = array(
        'sku' => $sku,
        'quantity' => $quantity,
    );
    $options = array(
        'http' => array(
            'header'  => "Content-Type: application/json\r\n" .
                         "Authorization: Bearer " . $api_secret_key . "\r\n",
            'method'  => 'POST',
            'content' => json_encode($data)
        )
    );

    $context  = stream_context_create($options);
    $result = file_get_contents($rsg_store_api_end_point, false, $context);

    if ($result === FALSE) {
        echo 'Failed to send consumed quantity to third-party resource';
    } else {
        echo 'Consumed quantity sent successfully';
    }
}

// Fetch 
function fetch_quantity_from_third_party($sku) {
    // API endpoint of the third-party resource
    $rsg_store_api_end_point = 'https://third-party.com/api/quantity';

    // Third-party API credentials
    $api_secret_key = 'your_api_key';

    // Prepare GET request
    $options = array(
        'http' => array(
            'header'  => "Authorization: Bearer " . $api_secret_key . "\r\n",
            'method'  => 'GET',
        )
    );

    // Send GET request
    $context  = stream_context_create($options);
    $result = file_get_contents($rsg_store_api_end_point . '?sku=' . $sku, false, $context);

    // Check if request was successful
    if ($result === FALSE) {
        echo 'Failed to fetch quantity from third-party resource';
    } else {
        $quantity = json_decode($result, true);
        echo 'Quantity fetched successfully: ' . $quantity;
    }
}
*/
// send_consumed_quantity('your_product_sku', 10);

// fetch_quantity_from_third_party('your_product_sku');

?>
